<?php
// +----------------------------------------------------------------------+
// | URL短縮システム(TynyDokaan)                                          |
// +----------------------------------------------------------------------+
// | Copyright (c) 加速ツールドットコム                                   |
// +----------------------------------------------------------------------+
// | Authors: K.IKIDA                                                     |
// +----------------------------------------------------------------------+
	require_once('config.php');
	
	session_start();

	if($_SESSION['password'] != $pstrPassword){
		//ログインしていないときはログイン画面に強制移動
		header('Location: login.php');
		exit;
	}
	
	
	if($_GET['mode'] == 'dl' ){
		//ダウンロード処理
		download_proc();
		exit;
	}

	if($_GET['mode'] == 'bk' ){
		//ダウンロード処理
		backup_proc();
		exit;
	}


	//アップロード処理
	upload_proc();

function download_proc(){
	global $pstrDatafile;
	
	if( ! file_exists($pstrDatafile)){
		header('HTTP/1.0 404 Not Found');
		print('<h1>Not Found</h1>');
		exit;
	}
	
	
	$strDLfile=$pstrDatafile;
	$intDLfileSize=filesize($strDLfile);
	$strMime='text/plain';
	
	header('Content-Type: "' . $strMime . '"');
	header('Content-Disposition: attachment; filename="'.$strDLfile.'"');
	header('Content-Transfer-Encoding: binary');
	header('Expires: 0');

	if(strstr($_SERVER['HTTP_USER_AGENT'],'MSIE')){

		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
	} else {
		header('Pragma: no-cache');	
	}
	header('Content-Length: ' . $intDLfileSize);

	readfile($strDLfile);

}

function upload_proc(){
	global $pstrDatafile;
	
	//もし一時ファイルが存在していたら消す
	if(file_exists('datalist.tmp')){
		if( ! unlink('datalist.tmp')){
			header('HTTP/1.1 403 Forbidden');	
			exit;
		}
	}

	//アップロードファイル名取得
	$strUPfile=$_FILES['upload_file']['name'];
	
	//アップロードエラーチェック
	if($_FILES['upload_file']['error'] != UPLOAD_ERR_OK){
		header('HTTP/1.1 403 Forbidden');	
		print('<h1>Forbidden</h1>');
		exit;
	}

	//アップロード最終処理
	if( ! move_uploaded_file($_FILES['upload_file']['tmp_name'],$strUPfile)){
		header('HTTP/1.1 403 Forbidden');	
		print('<h1>Forbidden</h1>');
		exit;
	}


	//実データファイルに置き換え
	if(file_exists('datalist.tmp')){
		//データファイルをオンメモリー
		$fTmpfile=fopen('datalist.tmp' , 'r');
		while($lstBuf[]=fgets($fTmpfile,8192)){
		}
		fclose($fTmpfile);	
	} else {
		header('HTTP/1.1 403 Forbidden');	
		print('<h1>Forbidden</h1>');
		exit;
	}

	$fDatafile=fopen($pstrDatafile , 'w');
	flock($fDatafile,LOCK_EX);
	for($intI=0 ; $intI < count($lstBuf) ; $intI++){
		fputs($fDatafile,$lstBuf[$intI]);
	}
	flock($fDatafile,LOCK_UN);
	fclose($fDatafile);	

	//一時ファイル削除
	unlink('datalist.tmp');

	print('<p>success</p>');


}
function backup_proc(){
	global $pstrDatafile;
	
	if( ! file_exists($pstrDatafile)){
		print('>ND<');
		exit;
	}	
	
	$strBkfile = 'datalist_bak.php';

	if (!copy($pstrDatafile, $strBkfile)) {
    	print('>NG<');
	} else {
    	print('>OK<');
	}	
	
}	
?>